/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.ruleGenerators;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.rules.lad.core.BinaryData;
import weka.classifiers.rules.lad.core.BinaryInstance;
import weka.classifiers.rules.lad.core.BinaryRule;
import weka.classifiers.rules.lad.core.Literal;
import weka.classifiers.rules.lad.ruleGenerators.RuleGenerator;

public class MaxRuleGenerator
extends RuleGenerator {
    private static final long serialVersionUID = 8175941261292479958L;
    private ArrayList<Literal> mLiterals = new ArrayList();
    private boolean mInstClass;

    @Override
    public void generateRules(BinaryData trainingData) {
        this.mTrainingData = trainingData;
        int i = 0;
        while (i < this.mTrainingData.numInstances()) {
            this.addRule(this.expand(this.mTrainingData.getInstance(i)));
            ++i;
        }
    }

    private BinaryRule expand(BinaryInstance binaryObservation) {
        this.generateMinterm(binaryObservation);
        this.mInstClass = binaryObservation.instanceClass();
        RuleGenerator.Node principal = new RuleGenerator.Node(this);
        RuleGenerator.Node naoCobertas = new RuleGenerator.Node(this);
        int i = 0;
        while (i < this.mTrainingData.numInstances()) {
            BinaryInstance obs = this.mTrainingData.getInstance(i);
            if (this.verifyCovering(obs)) {
                principal.addInstance(obs);
            } else {
                naoCobertas.addInstance(obs);
            }
            ++i;
        }
        boolean safetyMode = false;
        if (principal.getPurity(this.mInstClass) < this.mMinimumPurity) {
            safetyMode = true;
        }
        while (this.mLiterals.size() > 0) {
            RuleGenerator.Node melhor = null;
            Literal melhorLiteral = null;
            ArrayList<Literal> literais = new ArrayList<Literal>(this.mLiterals);
            for (Literal l : literais) {
                this.mLiterals.remove(l);
                RuleGenerator.Node novo = new RuleGenerator.Node((RuleGenerator)this, principal);
                RuleGenerator.Node listaNaoCobertasDaIteracao = new RuleGenerator.Node((RuleGenerator)this, naoCobertas);
                for (BinaryInstance b : naoCobertas.getPositiveInstances()) {
                    if (!this.verifyCovering(b)) continue;
                    novo.addInstance(b);
                    listaNaoCobertasDaIteracao.removeInstance(b);
                }
                for (BinaryInstance b : naoCobertas.getNegativeInstances()) {
                    if (!this.verifyCovering(b)) continue;
                    novo.addInstance(b);
                    listaNaoCobertasDaIteracao.removeInstance(b);
                }
                if (novo.getPurity(this.mInstClass) >= this.mMinimumPurity || safetyMode && Math.abs(novo.getPurity(this.mInstClass) - principal.getPurity(this.mInstClass)) < 10000.0) {
                    double discrP = this.discrepancy(naoCobertas.getPositiveInstances());
                    double discrN = this.discrepancy(naoCobertas.getNegativeInstances());
                    if (this.mInstClass) {
                        novo.setDiscrepancy(discrP / discrN);
                    } else {
                        novo.setDiscrepancy(discrN / discrP);
                    }
                    if (melhor == null) {
                        melhor = novo;
                        melhorLiteral = l;
                    } else if (this.mInstClass) {
                        if (novo.numPositiveInstances() > melhor.numNegativeInstances()) {
                            melhor = novo;
                            melhorLiteral = l;
                        } else if (novo.numPositiveInstances() == melhor.numPositiveInstances() && novo.getDiscrepancy() < melhor.getDiscrepancy()) {
                            melhor = novo;
                            melhorLiteral = l;
                        }
                    } else if (novo.numNegativeInstances() > melhor.numNegativeInstances()) {
                        melhor = novo;
                        melhorLiteral = l;
                    } else if (novo.numNegativeInstances() == melhor.numNegativeInstances() && novo.getDiscrepancy() < melhor.getDiscrepancy()) {
                        melhor = novo;
                        melhorLiteral = l;
                    }
                }
                this.mLiterals.add(l);
            }
            if (melhorLiteral == null) break;
            principal = melhor;
            this.mLiterals.remove(melhorLiteral);
            for (BinaryInstance obs : principal.getPositiveInstances()) {
                naoCobertas.removeInstance(obs);
            }
            for (BinaryInstance obs : principal.getNegativeInstances()) {
                naoCobertas.removeInstance(obs);
            }
        }
        return new BinaryRule(this.mLiterals, this.mInstClass, principal.getPurity(this.mInstClass));
    }

    private void generateMinterm(BinaryInstance binaryObservation) {
        this.mLiterals.clear();
        int i = 0;
        while (i < binaryObservation.numAttributes()) {
            if (!binaryObservation.isMissingAttribute(i)) {
                this.mLiterals.add(new Literal(i, binaryObservation.getAttributeAt(i)));
            }
            ++i;
        }
    }

    private boolean verifyCovering(BinaryInstance obs) {
        for (Literal l : this.mLiterals) {
            int indice = l.getAtt();
            if (indice < 0 || indice >= obs.numAttributes()) {
                return false;
            }
            if (!(obs.isMissingAttribute(indice) ? this.mInstClass == obs.instanceClass() : l.getSign().booleanValue() != obs.getAttributeAt(indice).booleanValue())) continue;
            return false;
        }
        return true;
    }

    private double discrepancy(ArrayList<BinaryInstance> observationList) {
        int contador = 0;
        double discrepancia = 0.0;
        for (BinaryInstance obs : observationList) {
            int dist = 0;
            int numberOfOccurrences = obs.numOfOccurrences();
            for (Literal l : this.mLiterals) {
                if (obs.isMissingAttribute(l.getAtt())) {
                    if (this.mInstClass != obs.instanceClass()) continue;
                    dist += numberOfOccurrences;
                    continue;
                }
                if (l.getSign().booleanValue()) {
                    if (obs.getAttributeAt(l.getAtt()).booleanValue()) continue;
                    dist += numberOfOccurrences;
                    continue;
                }
                if (!obs.getAttributeAt(l.getAtt()).booleanValue()) continue;
                dist += numberOfOccurrences;
            }
            contador += numberOfOccurrences;
            discrepancia += (double)dist;
        }
        return discrepancia /= 1.0 + (double)contador;
    }

    @Override
    public String globalInfo() {
        return "Implements the Maximized Prime Patterns heuristic described in the \"Maximum Patterns in Datasets\" paper. It generates one pattern (rule) per observation, while attempting to: (i) maximize the coverage of other observations belonging to the same class, and (ii) preventing the coverage of too many observations from outside that class. The amount of \"outside\" coverage allowed is controlled by the minimum purity parameter (from the main LAD classifier).";
    }

    @Override
    public String[] getOptions() {
        return new String[0];
    }

    @Override
    public void setOptions(String[] options) throws Exception {
    }

    @Override
    public Enumeration listOptions() {
        return new Vector(0).elements();
    }
}

